/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import io.netty.buffer.ByteBuf;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketRelicTweak
implements CustomPacketPayload {
    private final int container;
    private final int slot;
    private final String ability;
    private final Operation operation;
    private final boolean withShift;
    public static final CustomPacketPayload.Type<PacketRelicTweak> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"relic_tweak"));
    public static final StreamCodec<ByteBuf, PacketRelicTweak> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PacketRelicTweak::getContainer, (StreamCodec)ByteBufCodecs.INT, PacketRelicTweak::getSlot, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketRelicTweak::getAbility, (StreamCodec)ByteBufCodecs.idMapper(Operation.BY_ID, Operation::getId), PacketRelicTweak::getOperation, (StreamCodec)ByteBufCodecs.BOOL, PacketRelicTweak::isWithShift, PacketRelicTweak::new);

    public PacketRelicTweak(int container, int slot, String ability, Operation operation) {
        this(container, slot, ability, operation, false);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ItemStack stack;
            Player player;
            block16: {
                player = ctx.player();
                if (player.containerMenu.containerId != this.container) {
                    PacketRelicTweak.causeError(player);
                    return;
                }
                stack = DescriptionUtils.gatherRelicStack(player, this.slot);
                Item patt0$temp = stack.getItem();
                if (!(patt0$temp instanceof IRelicItem)) {
                    PacketRelicTweak.causeError(player);
                    return;
                }
                IRelicItem relic = (IRelicItem)patt0$temp;
                AbilityData entry = relic.getAbilityData(this.ability);
                if (entry == null) {
                    return;
                }
                switch (this.operation.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        boolean result = false;
                        if (this.withShift) {
                            while (relic.upgrade(player, stack, this.ability)) {
                                result = true;
                            }
                        } else {
                            result = relic.upgrade(player, stack, this.ability);
                        }
                        if (!result) break;
                        break block16;
                    }
                    case 2: {
                        boolean result = false;
                        if (this.withShift) {
                            while (relic.getAbilityQuality(stack, this.ability) != relic.getMaxQuality() && relic.reroll(player, stack, this.ability)) {
                                result = true;
                            }
                        } else {
                            result = relic.reroll(player, stack, this.ability);
                        }
                        if (!result) break;
                        break block16;
                    }
                    case 0: {
                        if (relic.reset(player, stack, this.ability)) break block16;
                    }
                }
                return;
            }
            try {
                player.containerMenu.getSlot(this.slot).set(stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                PacketRelicTweak.causeError(player);
            }
        });
    }

    private static void causeError(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"info.relics.researching.wrong_container").withStyle(ChatFormatting.RED), false);
        player.closeContainer();
    }

    public int getContainer() {
        return this.container;
    }

    public int getSlot() {
        return this.slot;
    }

    public String getAbility() {
        return this.ability;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isWithShift() {
        return this.withShift;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketRelicTweak)) {
            return false;
        }
        PacketRelicTweak other = (PacketRelicTweak)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainer() != other.getContainer()) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.isWithShift() != other.isWithShift()) {
            return false;
        }
        String this$ability = this.getAbility();
        String other$ability = other.getAbility();
        if (this$ability == null ? other$ability != null : !this$ability.equals(other$ability)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PacketRelicTweak;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainer();
        result = result * 59 + this.getSlot();
        result = result * 59 + (this.isWithShift() ? 79 : 97);
        String $ability = this.getAbility();
        result = result * 59 + ($ability == null ? 43 : $ability.hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    public String toString() {
        return "PacketRelicTweak(container=" + this.getContainer() + ", slot=" + this.getSlot() + ", ability=" + this.getAbility() + ", operation=" + String.valueOf((Object)this.getOperation()) + ", withShift=" + this.isWithShift() + ")";
    }

    public PacketRelicTweak(int container, int slot, String ability, Operation operation, boolean withShift) {
        this.container = container;
        this.slot = slot;
        this.ability = ability;
        this.operation = operation;
        this.withShift = withShift;
    }

    public static enum Operation {
        RESET(0),
        UPGRADE(1),
        REROLL(2);

        public static final IntFunction<Operation> BY_ID;
        private final int id;

        public int getId() {
            return this.id;
        }

        private Operation(int id) {
            this.id = id;
        }

        static {
            BY_ID = ByIdMap.continuous(Operation::getId, (Object[])Operation.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

